/* 
 * File:   rgb.h
 * Author: Nicholas
 *
 * Created on 12 October 2025, 3:20 PM
 */

#ifndef RGB_H
#define	RGB_H

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct { unsigned char g, r, b; } rgb;

void rainbow(rgb* pRGB, unsigned char pos);
void xmas(rgb* pRGB, unsigned char pos);
void ice(rgb* pRGB, unsigned char pos);
void xmas2(rgb* pRGB, unsigned char pos);
void colourScheme(rgb* pRGB, unsigned char scheme, unsigned char pos);
void rainbowBright(rgb* pRGB, unsigned char pos, unsigned char bright);
void xmasBright(rgb* pRGB, unsigned char pos, unsigned char bright);
void schemeBright(rgb* pRGB, unsigned char scheme, unsigned char pos, unsigned char bright);
void colourSchemeBright(rgb* pRGB, unsigned char scheme, unsigned char pos, unsigned char bright);

static inline void black(rgb* pRGB) {
    pRGB->r = pRGB->g = pRGB->b = 0;
}

#if 0
inline void white(rgb* pRGB) {
    pRGB->r = pRGB->g = pRGB->b = 255;
}
#endif

static inline void addRGB(rgb* pRGB, unsigned char r, unsigned char g, unsigned char b) {
    if( pRGB->r + r > 255 )
      pRGB->r = 255;
    else
      pRGB->r += r;

    if( pRGB->g + g > 255 )
      pRGB->g = 255;
    else
      pRGB->g += g;

    if( pRGB->b + b > 255 )
      pRGB->b = 255;
    else
      pRGB->b += b;
}

static inline void fade(rgb* pRGB, unsigned char amt) {
    pRGB->r = pRGB->r * amt / 256;
    pRGB->g = pRGB->g * amt / 256;
    pRGB->b = pRGB->b * amt / 256;
}

#ifdef	__cplusplus
}
#endif

#endif	/* RGB_H */

